$(document).ready(function() {
	$('[data-type="timer"]').each(function() {
		var _this = $(this);
		_this.fadeOut(400, function() {
			_this.css('white-space', 'nowrap');
			var duration = parseFloat(_this.attr('data-duration')) * 1000;

			var timer = null;

			function update() {
				duration -= 1000;
				if (duration > 0) {
					var d = duration / 1000;
					var min = parseInt(d / 60);
					if (min < 10) min = '0' + min;
					var sec = (d % 60);
					if (sec < 10) sec = '0' + sec;
					_this.html('<b>' + min + ' min ' + sec + ' sec</b>');
				} else {
					window.clearInterval(timer);
					_this.fadeOut(400, function() {
						_this.html('Zakończona');
						_this.fadeIn();
					});
				}
			}

			update();
			timer = window.setInterval(update, 1000);

			_this.fadeIn();
		});
	});
});
